/*************************************************************************
 * DISCLAIMER                                                            *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/
/*******************************************************************
  Copyright (c) 2011 Freescale Semiconductor
  \file     	main.c
  \brief    	main file for bootloader
  \author   	Norman Guo
  \version    1.0
  \date     	26/Sep/2011
*********************************************************************/



#include <hidef.h>                               // for EnableInterrupts macro
#include "derivative.h"                          // include peripheral declarations
#include "doonstack.h"                           // include flash utilities
#include "sci.h"

#pragma MESSAGE DISABLE C4000                    // Condition always TRUE
#pragma MESSAGE DISABLE C20001                   // Different value of stackpointer depending on control-flow

// These vars and functions are defined in boot.c
extern word RAMEndP1;
extern const byte const_node_addr;
extern void boot_start(byte boot_flag);
extern byte get_node_addr(void);


void init_CPU(void);
void init_PLL(void);
void init_TPM1(void);
void init_IO(void);
void init_IRQ(void);
void init_TPM2(void);

void main(void) 
{
  byte timeout = 0, pointer = 0, node_addr = 0, temp=0;
  byte sci_buffer[SCI_BUFFER_SIZE];
    
  init_CPU( ); 
  init_PLL( );
  init_TPM1( );
  init_IO( );
  init_IRQ( );
  init_TPM2( );
  init_SCI( );
  node_addr = get_node_addr( );
  
  EnableInterrupts;                              // enable interrupts
  
  while(1)
  {
    pointer = 0;
    while(1)
    {
      temp = sci_getchar(&timeout);
      if(timeout)
      {
        if(pointer > 0)
        {
          break;
        }
        pointer = 0;
        timeout = 0;
      }
      else
      {
        sci_buffer[pointer] = temp;
        pointer++;
      }
    }
    
    // now pointer equals the received datalength
    // check_CRC();                                                  // if CRC is implemented
    
    if(sci_buffer[0] != node_addr || sci_buffer[1] != 0x43)          // check node address and the function code  
      continue;                                                      // 0x43 is for firmware updating
    
    if(sci_buffer[3] == 'B')                                         // request enter boot mode
    {
      DisableInterrupts;
      __asm LDHX RAMEndP1;
      __asm TXS; 
      boot_start(1);
    }
    else if(sci_buffer[3] == 'V')                                    // request enter verify mode
    {
      DisableInterrupts;
      __asm LDHX RAMEndP1;
      __asm TXS; 
      boot_start(2);
    }
    else
    {
      _asm nop;
    }
   
    for(pointer = 0;pointer < SCI_BUFFER_SIZE;pointer ++)            // clear sci buffer
      sci_buffer[pointer] = 0;
    __RESET_WATCHDOG();
  }
}

void init_CPU(void)
{
  SOPT = 0x53;                 
  SPMSC1 = 0x1C;                
  SPMSC2 = 0x00; 
  SMCLK = 0x17;    
} 

// FEI mode, Bus = 20MHz
void init_PLL(void)
{
  // ICGC1: HGO=0,RANGE=1,REFS=0,CLKS1=0,CLKS0=1,OSCSTEN=1,LOCD=0,??=0
  ICGC1 = 0x4C;                 
  // ICGC2: LOLRE=0,MFD2=1,MFD1=1,MFD0=1,LOCRE=0,RFD2=0,RFD1=0,RFD0=0
  ICGC2 = 0x70;                 
  if (*(unsigned char*)0xFFBE != 0xFF) {         // Test if the device trim value is stored on the specified address
    ICGTRM = *(unsigned char*)0xFFBE;            // Initialize ICGTRM register from a non volatile memory
  }
  while(!ICGS1_LOCK) 
  {
    __RESET_WATCHDOG();
  }
}

// This routine is nessesary, it is used for timing of Modbus
void init_TPM1(void)
{
  TPM1SC = 0x00;
  TPM1MOD = 0x00;
  TPM1C0SC = 0x10;
  TPM1C0V = 0x4E4D;                              // 3.5T at 20MHz 4800 bps
//TPM1C0V = 0x2727;                              // 3.5T at 20MHz 9600 bps
  TPM1C1SC = 0x10;
  TPM1C1V = 0x5988;                              // 4T at 20MHz  4800 bps
//TPM1C1V = 0x2CB7;                              // 4T at 20MHz  9600 bps
  TPM1CNTH = 0x00;
  TPM1SC = 0x0B;
}

// This is demo code
void init_IO(void)
{
  PTCDD_PTCDD3 = 1;                              // output led D5
} 

// This is demo code
void init_IRQ(void)
{
  IRQSC_IRQPE = 1;
  IRQSC_IRQIE = 1;        
} 

// This is demo code
void init_TPM2(void)
{
  TPM2SC = 0x00;
  TPM2C0SC = 0x50;                               // Set output compare mode and enable compare interrupt
  
//TPM2C0V = 0x5B87U;                             // 150 ms at 20MHz
//TPM2MOD = 0x5B87U;
  
  TPM2C0V = 0xB70FU;                             // 300 ms at 20MHz
  TPM2MOD = 0xB70FU;
  
//TPM2C0V = 0xFFFFU;                             // 419 ms at 20MHz
//TPM2MOD = 0xFFFFU;
  
  TPM2CNTH = 0x00;                               // Reset HW Counter
  TPM2SC = 0x0F;                                 // Set prescaler and run counter
}


// This routine is nessesary, all unused interrupt are mapped to this routine
void interrupt Unused_service(void)
{
  asm nop;
}

// This is demo code
void interrupt Vtpm2ovf_service(void)
{
  asm nop;
}

// This is demo code
void interrupt Vtpm2ch1_service(void)
{
  asm nop;
}

// This is demo code
void interrupt Vtpm2ch0_service(void)
{
  (void)TPM2C0SC;
  TPM2C0SC_CH0F = 0;                             // Clear interrupt flag
  PTCD_PTCD3 = !PTCD_PTCD3;
  
}

// This is demo code
void interrupt Virq_service(void)
{
  IRQSC_IRQACK = 1;                              // Clear the interrupt flag
}





